///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabAccountsDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND UserList_hWnd = NULL;
    static HWND Username_hWnd = NULL;
    static HWND Password_hWnd = NULL;

    if(xMessage == WM_INITDIALOG)
    {
        UserList_hWnd = GetDlgItem(xHandle, IDC_USERLIST);
        Username_hWnd = GetDlgItem(xHandle, IDC_USERNAME);
        Password_hWnd = GetDlgItem(xHandle, IDC_PASSWORD);

        int LVStyle = LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT;
        SendMessage(UserList_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)LVStyle);

        LV_COLUMN MyLVColumb;
        memset(&MyLVColumb, 0, sizeof(LV_COLUMN));

        // Create Listview columbs
        MyLVColumb.cx        = 130;
        MyLVColumb.pszText   = "User name";
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(UserList_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 130;
        MyLVColumb.pszText   = "Password";
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(UserList_hWnd, 1, &MyLVColumb);


        return TRUE;
    }

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDC_ADDBUTTON)
        {
            char Username[32 + 1];
            char Password[64 + 1];

            int UsernameLen = Get_TextEx(Username_hWnd, Username, 32);
            int PasswordLen = Get_TextEx(Password_hWnd, Password, 64);

            if(UsernameLen > 32 || UsernameLen <= 0)
            {
                MessageBox(xHandle, "You have to enter a username of atleast one character.", TitleCaption, 0);
                return TRUE;
            }

            if(PasswordLen > 32 || PasswordLen < 8)
            {
                MessageBox(xHandle, "You have to enter a password of atleast eight (8) characters.", TitleCaption, 0);
                return TRUE;
            }

            Set_Text(Username_hWnd, "");
            Set_Text(Password_hWnd, "");

            LV_ITEM MyLVItem;
            memset(&MyLVItem, 0, sizeof(LV_ITEM));

            MyLVItem.pszText = Username;
            MyLVItem.mask = LVIF_TEXT;
            MyLVItem.iSubItem = 0;
            ListView_InsertItem(UserList_hWnd, &MyLVItem);

            MyLVItem.pszText = Password;
            MyLVItem.mask = LVIF_TEXT;
            MyLVItem.iSubItem = 1;
            ListView_SetItem(UserList_hWnd, &MyLVItem);

            return TRUE;
        }

        if(wParam == IDC_REMOVEBUTTON)
        {
            int Selection = ListView_GetSelectionMark(UserList_hWnd);
            if(Selection > -1)
            {
                ListView_DeleteItem(UserList_hWnd, Selection);
            }
            return TRUE;
        }

        return FALSE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

